<?php

include('incapacidades.php');
include('seguridad_social.php');
include('vacaciones.php');


$base='wwwsolin_outsourcing_2018';
$baseConfig='wwwsolin_configuracion_2018';

$fn_contectar_db=function($base){
	return $conectar=mysqli_connect("localhost", "wwwsolin_solinix", "Holasolinix1*", $base);
};

$fn_contectar_db_config=function($baseConfig){
	return $conectar=mysqli_connect("localhost", "wwwsolin_solinix", "Holasolinix1*", $baseConfig);
};

$fn_cerrar_db=function($conectar){
	mysqli_close($conectar);
};

// Cantidad de días que tiene un mes;
$fn_total_dias_mes=function($mes, $ano){
	$total_dias = cal_days_in_month(CAL_GREGORIAN, $mes, $ano); // 31
	if($total_dias==28 || $total_dias==29 || $total_dias==31): $total_dias=30; endif;
	return $total_dias;
};

// Cantidad real de días que tiene un mes;
$fn_total_dias_mes_real=function($mes, $ano){
	$total_dias = cal_days_in_month(CAL_GREGORIAN, $mes, $ano); // 31
	return $total_dias;	
};

// Mostrar tecxto periodo pago 
$fn_text_periodo_pago=function($tipo_nom, $perio_nom){
	
	if($tipo_nom==1){
	
		if($perio_nom==1) $mostrar='Primer quincena';
		elseif($perio_nom==2) $mostrar='Segunda quincena';
	}
	elseif($tipo_nom==2) $mostrar='Mensual';

	return $mostrar;
};

// Días a pagar
$fn_dias_pagar=function($total_dias, $dias_incapacidad, $notificacion_vaca, $dias_vacaciones, $dias_vacaciones_laborados, $dias_ingreso, $dias_retiro, $dias_no_remun, $dias_labor_no_remun, $perio_nom){

	/*echo "<br>dias_no_remun: ".$dias_no_remun;
	echo "<br>dias_labor_no_remun: ".$dias_labor_no_remun;
	echo "<br>dias_incapacidad: ".$dias_incapacidad;
	echo "<br>dias_vacaciones: ".$dias_vacaciones;
	echo "<br>notificacion_vaca: ".$notificacion_vaca;*/
	
	$sum_dias=$dias_vacaciones+$dias_incapacidad;
	if($dias_retiro!=''): $dias_calculo=$dias_retiro; //Si tiene retiro, pone los dias de retiro
	elseif($dias_incapacidad!='' || $notificacion_vaca=='1'):
		//Si la persona no tiene dias trabajados en las vacaciones
		if($dias_vacaciones_laborados=='0'): 
			$dias_calculo=$total_dias-$dias_incapacidad-$dias_vacaciones-$dias_no_remun; //Si tiene incapacidad o vacaciones toma el total de los días menos la novedad
			if($dias_calculo<0): $dias_calculo=0; endif;
			//HAROLDif($dias_vacaciones==0): $dias_calculo=0; endif;
			
			return $dias_calculo;
		endif;

		//Si la persona tiene dias de incapacidad 
		if($dias_incapacidad!='0'): 
			$dias_calculo=$total_dias-$dias_incapacidad-$dias_vacaciones; //Si tiene incapacidad o vacaciones toma el total de los días menos la novedad
			if($dias_calculo<0): $dias_calculo=0; endif;	

		endif;

		//Si la persona no tiene días trabajados en las vacaciones y no tiene días de vacaciones, pero tiene notificación de vacaciones, es porque en este periodo no trabajo sigue en vacaciones. Predomina las vacaiones
		if($dias_vacaciones_laborados=='0' && $dias_vacaciones=='0' && $dias_labor_no_remun=='0'): $dias_calculo=0; endif;

		//Si la persona tiene días trabajados en las vacaciones
		if($dias_vacaciones_laborados!='0' && $dias_vacaciones_laborados!=''): $dias_calculo=$dias_vacaciones_laborados-$dias_incapacidad; endif;

		//Si la persona tiene días trabajados en la licencia no remunerada
		if($dias_labor_no_remun!='0' && $dias_no_remun!=''): $dias_calculo=$dias_no_remun-$dias_vacaciones_laborados-$dias_incapacidad; endif;
	
	elseif($dias_incapacidad=='' && ($notificacion_vaca=='' or $notificacion_vaca=='0') && $dias_labor_no_remun!=''):
		//Si la persona tiene vacaciones no remunerada
		$dias_calculo=$dias_labor_no_remun;
			
	else:
		if($dias_ingreso!='' && $dias_vacaciones_laborados=='' && $dias_incapacidad==''):
			 $dias_calculo=$dias_ingreso; //Si tiene ingreso, toma los días de ingreso
		else:
			 $dias_calculo=$total_dias; 
		endif;
	endif;

	return $dias_calculo;

};

// Días de ingreso
/*$fn_dias_ingreso=function($rr_periodo_pagar, $fn_explode_dato, $dia, $mes, $ano, $mes_per, $ano_per, $perio_nom){

	//Obtenemos el ultimo día del periodo
	$dato=$fn_explode_dato("-", $rr_periodo_pagar);
	$dias_comienzo=$dato[0];
	$dias_final=$dato[1];

	//Primera quincena
	if($perio_nom==1){
		if($dia>=$dias_final && $mes==$mes_per && $ano==$ano_per) $total_dias=0;
		elseif($dia<$dias_final  && $mes==$mes_per && $ano==$ano_per) $total_dias=$dias_final-$dia+1;
		elseif($mes<$mes_per && $ano<=$ano_per) $total_dias=$dias_final;
		elseif($ano<$ano_per) $total_dias=$dias_final;
		elseif($mes>$mes_per || $ano>=$ano_per) $total_dias=0;
	}
	//Segunda quincena
	if($perio_nom==2){
		if($dia>$dias_comienzo && $mes==$mes_per && $ano==$ano_per) $total_dias=$dias_final-$dia+1; 
		elseif($dia<=$dias_comienzo && $mes==$mes_per && $ano==$ano_per) $total_dias=$dias_comienzo; 
		elseif($mes<$mes_per && $ano<=$ano_per) $total_dias=$dias_comienzo;
		elseif($ano<$ano_per) $total_dias=$dias_comienzo;
		elseif($mes>$mes_per || $ano>=$ano_per) $total_dias=0;
	}
	// Mensual
	if($perio_nom==''){
		if($dia>$dias_comienzo && $mes==$mes_per && $ano==$ano_per) $total_dias=$dias_final-$dia+1;
		elseif($mes<$mes_per && $ano<=$ano_per) $total_dias=$dias_final; 
		elseif($ano<$ano_per) $total_dias=$dias_final; 
		elseif($mes>$mes_per || $ano>=$ano_per) $total_dias=0;
	}

	return $total_dias;

};*/

// Función obtener valores de novedades retiro
$fn_retiro_novedades=function($fn_nombre_novedades, $rr_periodo_pagar, $fn_explode_dato, $base, $cc, $mes_per, $ano_per, $id_master, $cta_seleccionada, $perio_nom, $salario){

	//Obtenemos el ultimo día del periodo
	$dato=$fn_explode_dato("-", $rr_periodo_pagar);
	$dias_comienzo=$dato[0];
	$dias_final=$dato[1];

	// variables inicializadas
	$sql="select dias_nom_nov, fecha_ing_nom_nov, fecha_fin_nom_nov, id_nom_nov, tipo_nom_nov from nomina_novedades where MONTH(fecha_fin_nom_nov)=$mes_per and YEAR(fecha_fin_nom_nov)=$ano_per and id_master_fk_nom_nov=$id_master and id_cta_fk_nom_nov=$cta_seleccionada and cc_nom_nov=$cc and tipo_nom_nov=1 and liq_nom_nov=0";
	$conNOV=mysqli_query($base,$sql);
	$resNOV=mysqli_fetch_assoc($conNOV);
	$id_nom_nov=$resNOV['id_nom_nov'];
	$dias_nom_nov=$resNOV['dias_nom_nov'];
	$fecha_ing_nom_nov=$resNOV['fecha_ing_nom_nov'];
	$fecha_fin_nom_nov=$resNOV['fecha_fin_nom_nov'];
	$tipo_nom_nov=$resNOV['tipo_nom_nov'];
	

	//Primera quincena o mensual 
	if($perio_nom==1 || $perio_nom==''):
		if($dias_nom_nov<=$dias_final && $dias_nom_nov>=$dias_comienzo):
			$dias_totales=$dias_nom_nov;
			$dias_ret_real=$dias_nom_nov;
		endif;
	endif;

	//Segunda quincena
	if($perio_nom==2):
		if($dias_nom_nov<=$dias_final && $dias_nom_nov>=$dias_comienzo):
			$dias_totales=$dias_nom_nov-$dias_comienzo+1;
			$dias_ret_real=$dias_nom_nov;
		endif;
	endif;

	//Valor del retiro
	$valor_retiro=round(($salario / 30) * $dias_totales);

	//Obtenemos el tipo de novedad
	$novedad=$fn_nombre_novedades($tipo_nom_nov);

	if($tipo_nom_nov==1) $RET='X';
	
	//Si hay días creamos el array con los datos
	if($dias_totales!=0 && $dias_totales!='') $array_datos_novedades[]=array('id_retiros'=>$id_nom_nov, 'dias_retiros'=>$dias_totales, 'fecha_ing_retiros'=>$fecha_ing_nom_nov, 'fecha_fin_retiros'=>$fecha_fin_nom_nov, 'cc_retiros'=>$cc, 'novedad_retiros'=>$novedad, 'vr_retiros'=>$valor_retiro, 'dias_ret_real'=>$dias_totales);
	
	return $array_datos_novedades;
};

// Función obtener valores de novedades ingreso
$fn_ingreso_novedades=function($fn_explode_fecha, $fn_nombre_novedades, $rr_periodo_pagar, $fn_explode_dato, $base, $cc, $mes_per, $ano_per, $id_master, $cta_seleccionada, $perio_nom, $salario){

	//Obtenemos el ultimo día del periodo
	$dato=$fn_explode_dato("-", $rr_periodo_pagar);
	$dias_comienzo=$dato[0];
	$dias_final=$dato[1];

	// variables inicializadas
	$sql="select dias_nom_nov, fecha_ing_nom_nov, fecha_fin_nom_nov, id_nom_nov, tipo_nom_nov from nomina_novedades where mes_apli_nom_nov=$mes_per and ano_apli_nom_nov=$ano_per and id_master_fk_nom_nov=$id_master and id_cta_fk_nom_nov=$cta_seleccionada and cc_nom_nov=$cc and tipo_nom_nov=11 and liq_nom_nov=0";
	$conNOV=mysqli_query($base,$sql);
	$resNOV=mysqli_fetch_assoc($conNOV);
	$id_nom_nov=$resNOV['id_nom_nov'];
	$fecha_ing_nom_nov=$resNOV['fecha_ing_nom_nov'];
	$dato_fecha=$fn_explode_fecha($fecha_ing_nom_nov);
	$tipo_nom_nov=$resNOV['tipo_nom_nov'];
	//Valor del retiro
	$valor_retiro=round(($salario / 30) * $dato_fecha['dia']);

	//Primera quincena o mensual 
	if($perio_nom==1 || $perio_nom==''):
		if($dato_fecha['dia']<=$dias_final && $dato_fecha['dia']>=$dias_comienzo):
			$dias_totales=$dias_final-$dato_fecha['dia']+1;
			$dias_ing_real=$dias_totales;
		endif;
	endif;

	//Segunda quincena
	if($perio_nom==2):
		if($dato_fecha['dia']<=$dias_final && $dato_fecha['dia']>=$dias_comienzo):
			$dias_totales=$dias_final-$dato_fecha['dia']+1;
			$dias_ing_real=$dias_totales;
		endif;
	endif;

	//Obtenemos el tipo de novedad
	$novedad=$fn_nombre_novedades($tipo_nom_nov);

	//Si hay días creamos el array con los datos
	if($dias_totales!=0 && $dias_totales!='') $array_datos_ing_novedades[]=array('id_ingresos'=>$id_nom_nov, 'dias_ingresos'=>$dias_totales, 'fecha_ing_ingresos'=>$fecha_ing_nom_nov, 'fecha_fin_ingresos'=>'0000-00-00', 'cc_ingresos'=>$cc, 'novedad_ingresos'=>$novedad, 'vr_ingresos'=>$valor_retiro, 'dias_ing_real'=>$dias_ing_real);
	
	return $array_datos_ing_novedades;
};

// Calculo el total de días de un mes
$fn_dias_mes=function($mes, $ano){
    $number = cal_days_in_month(CAL_GREGORIAN, $mes, $ano); // 31
	return $number;
};

// Intervalo de días a pagar
$fn_periodo_pagar=function($fn_total_dias_mes, $mes, $ano, $perio_nom){

	$rr_total_dias=$fn_total_dias_mes($mes, $ano);

    if($perio_nom==null) $dias_periodo="1-".$rr_total_dias;
    elseif($perio_nom==1) $dias_periodo="1-15";
    else $dias_periodo="16-".$rr_total_dias;
    return $dias_periodo;

};

$fn_total_dias_pagar_periodo=function($tipo_nom){
	if($tipo_nom==1) $dias=15;
	else $dias=30;

	return $dias;
};

// Deducciones de la EPS
$fn_por_deducciones_eps=function($base, $id_deducciones_eps){
	$conDED=mysqli_query($base,"select por_eps_deducciones from deducciones_eps where id_deducciones_eps='$id_deducciones_eps'");
	$resDED=mysqli_fetch_assoc($conDED);
	$por_eps_deducciones=$resDED['por_eps_deducciones'];
	return $por_eps_deducciones/100;

};

// Deducciones de la AFP
$fn_por_deducciones_afp=function($base, $id_deducciones_afp, $fondo_pen){
	
	if($fondo_pen!=0){
		$conDED=mysqli_query($base,"select por_afp_deducciones from deducciones_afp where id_deducciones_afp='$id_deducciones_afp'");
		$resDED=mysqli_fetch_assoc($conDED);
		$por_afp_deducciones=$resDED['por_afp_deducciones']/100;
	}
	else{
		$por_afp_deducciones=0;
	}

	return $por_afp_deducciones;
};

// Calculo de valor a pagar dependiendo los días
$fn_valor_pagar=function($valor, $dias_completos,  $dias){
    return (($valor / $dias_completos) * $dias);
};

// Separar fechas
$fn_explode_fecha=function($fecha){
	$dato=explode("-", $fecha);
	$ano=$dato[0];
	$mes=$dato[1];
	$dia=$dato[2];

	$array_explode_fecha=array('ano'=>$ano, 'mes'=>$mes, 'dia'=>$dia);
	
	return $array_explode_fecha;
};

// Separar datos
$fn_explode_dato=function($caracter, $dato){
	$dato=explode($caracter, $dato);	
	return $dato;
};

//Datos usuarios de la nómina
$fn_datos_usuario=function($base, $cc, $cta_seleccionada, $id_master){
	$sqlUSU="select nom1, nom2, apell1, apell2 from usuario where cc=$cc and id_cta_fk_us=$cta_seleccionada and id_master_fk_us=$id_master";
	$conUSU=mysqli_query($base, $sqlUSU);
	$resUSU=mysqli_fetch_assoc($conUSU);
	
	$array_datos_usuario=array('nombre_usuario'=>$resUSU['nom1']." ".$resUSU['nom2']." ".$resUSU['apell1']." ".$resUSU['apell2']);

	return $array_datos_usuario;
};

//Datos novedades de la nómina
$fn_datos_novedades=function($base, $id_nom_nov, $cta_seleccionada, $id_master){
	$sqlNOMNOV="select tipo_nom_nov, fecha_ing_nom_nov, fecha_fin_nom_nov, dias_nom_nov, valor_nom_nov from nomina_novedades where id_nom_nov=$id_nom_nov and id_cta_fk_nom_nov=$cta_seleccionada and id_master_fk_nom_nov=$id_master";
	$conNOMNOV=mysqli_query($base, $sqlNOMNOV);
	$resNOMNOV=mysqli_fetch_array($conNOMNOV);
	$tipo_nom_nov=$resNOMNOV['tipo_nom_nov'];
	if($tipo_nom_nov==2) $IGE='X';
	if($tipo_nom_nov==3) $LMA='X';

	$array_nomina_novedades=array('tipo_nom_nov'=>$resNOMNOV['tipo_nom_nov'], 'fecha_ing_nom_nov'=>$resNOMNOV['fecha_ing_nom_nov'], 'fecha_fin_nom_nov'=>$resNOMNOV['fecha_fin_nom_nov'], 'dias_nom_nov'=>$resNOMNOV['dias_nom_nov'], 'valor_nom_nov'=>$resNOMNOV['valor_nom_nov'], 'IGE'=>$IGE, 'LMA'=>$LMA);

	return $array_nomina_novedades;
};

//Buscar datos en un array
$fn_buscar_datos_array=function($array, $dato, $campo){

	// Recorro el array para identificar si tiene los datos
	foreach($array as $array_datos):
		$dato_posicion_array=$array_datos['nro']-1; //Obtengo la posición del array no elconsecutivo
		$dato_cc_array=$array_datos[$campo]; //Obtengo el número de documento del array
		if($dato_cc_array==$dato):
			//Creo el array
			$respuesta=array('posicion'=>$dato_posicion_array, $campo=>$dato_cc_array);	
		endif;
	endforeach;
	//Returnamos el array
	return $respuesta;
};

//Sumar valores
$fn_sumar_valores=function($valor1, $valor2){
	$respuesta=$valor1+$valor2;
	return $respuesta;
};

$fn_aproxima_mil=function($ibc,$salario_minimo){
	//Aproxima valor al ingreso base al mil mas cercano
    $antes=$ibc;	
    $residuo=$ibc%1000;			
    if($residuo>500):	
        $x=1000-$residuo;
        $ing_base=$ibc+$x;					
    else:
        if($ibc==$salario_minimo): $ing_base=$antes;
        else: $ing_base=$ibc-$residuo;			
        endif;	
    endif;

	return $ing_base;

};

$fn_aproxima_cien=function($valor, $salario, $salario_minimo){
	//Aproxima valor al ingreso base al cien mas cercano
    $residuo=$valor%100;
	if($residuo>=51):
		$x=100-$residuo;
		$valor=$valor+$x;
	elseif($residuo==00):
		$valor=$valor;	
	else:
		$x=100-$residuo;
		if($salario_minimo==$salario): $valor=$valor+$x;
		else: $valor=$valor;
		endif;
	endif;
	
    return $valor;

};
// Retornar el 
$fn_zonas=function($baseConfi, $id_zona){
	$sqlCIU="select cod_zona, nom_zona from zona where id_zona=$id_zona";
	$conCIU=mysqli_query($baseConfi, $sqlCIU);
	$resCIU=mysqli_fetch_assoc($conCIU);
	//Creo el array
	$respuesta=array('nom_zona'=>$resCIU['nom_zona'], "cod_zona"=>$resCIU['cod_zona']);	
	//Retorno el array
	return $respuesta;


};

$cambia_numero=function($numero, $tam){
  $num=$numero;
  $cant=strlen($num);
  while($cant<$tam+1)
  	{
  	 	$num="0".$num;
  		$cant++;					
    }
  return $num;	
};

$fn_nombre_novedades=function($id_novedad){

	if($id_novedad==2): $nom_novedad='IGE:Incapacidad Enfermedad General'; endif;
	if($id_novedad==1): $nom_novedad='Retiro'; endif;
	if($id_novedad==3): $nom_novedad='LMA:Licencia de Maternidad'; endif;
	if($id_novedad==4): $nom_novedad='VAC:(Vacaciones)-(Licencia Remunerada)'; endif;
	if($id_novedad==5): $nom_novedad='SLN:(Licencia o permiso temporal)-(suspensión temporal del contrato de trabajo)'; endif;
	if($id_novedad==6): $nom_novedad='Prima de servicios'; endif;
	if($id_novedad==7): $nom_novedad='Cesantías'; endif;
	if($id_novedad==9): $nom_novedad='Intereses de Cesantía'; endif;
	if($id_novedad==8): $nom_novedad='Otras deducciones'; endif;
	if($id_novedad==11): $nom_novedad='Ingreso'; endif;
	if($id_novedad==12): $nom_novedad='Bonificaciones no salarial'; endif;

	return $nom_novedad;

}

?>