<?php

$fn_dias_total_incap=function($fecha_ini, $fecha_fin){

    $inicial=explode("-",$fecha_ini);
	$final=explode("-",$fecha_fin);
    //días proporcionales del primer mes
	$dias_mes = cal_days_in_month(CAL_GREGORIAN, $inicial[1], $inicial[0]); // 31
	if($inicial[2]<$dias_mes) $contador=$dias_mes-$inicial[2]; 
    elseif($inicial[2]==$dias_mes) $contador=30;
    // Días del mes final de la incapacidad 
    $dias_mesF = cal_days_in_month(CAL_GREGORIAN, $final[1], $final[0]); // 31
    if($final[2]<$dias_mesF) $contador=$contador+$final[2];
    elseif($final[2]==$dias_mesF) $contador=30;
    // Identifico la cantidad de meses entre el intervalo
    $fechainicial = new DateTime($fecha_ini);     
    $fechafinal = new DateTime($fecha_fin);
    $diferencia = $fechainicial->diff($fechafinal);
    $meses = (( $diferencia->y * 12 ) + $diferencia->m)-1;
    // sumo el total de días
    $contador=$contador+($meses*30);

    return $contador;
};

// Función obtener valores de novedades nomina
$fn_novedades=function($fn_dias_incapacidades, $fn_explode_dato, $rr_periodo_pagar, $base, $cc, $mes_per, $ano_per, $id_master, $cta_seleccionada, $perio_nom){

	//return var_dump($dato_fecha_fin);
	$sql="select cc_nom_nov, dias_nom_nov, fecha_ing_nom_nov, fecha_fin_nom_nov, tipo_nom_nov, valor_nom_nov from nomina_novedades where cc_nom_nov=$cc and id_cta_fk_nom_nov=$cta_seleccionada and id_master_fk_nom_nov=$id_master and tipo_nom_nov!=1";
	$conNOV=mysqli_query($base,$sql);
	$resNOV=mysqli_fetch_assoc($conNOV);
	if($resNOV){
		$dias_nom_nov=$resNOV['dias_nom_nov'];
		$fecha_ing_nom_nov=$resNOV['fecha_ing_nom_nov'];
		$fecha_fin_nom_nov=$resNOV['fecha_fin_nom_nov'];
		$valor_nom_nov=$resNOV['valor_nom_nov'];
		$tipo_nom_nov=$resNOV['tipo_nom_nov'];	
		if($tipo_nom_nov==2) $IGE='X';
		if($tipo_nom_nov==3) $LMA='X';

		// Días a pagar de las incapacidades
		$r_dias_nom_nov_pagar=$fn_dias_incapacidades($fn_explode_dato, $rr_periodo_pagar, $mes_per, $ano_per, $fecha_ing_nom_nov, $fecha_fin_nom_nov, $perio_nom);

		// Si no tiene incapacidad descara las novedades
		//Marcalos las novedades vacías, porque no tienen días de incapacidad
		if($r_dias_nom_nov_pagar==''){ 
			$IGE=''; 
			$LMA=''; 
		}
		// Valor a pagar de la incapacidad
		
		// Array con lo valores
		$array_nomina_novedades=array('dias_nom_nov'=>$r_dias_nom_nov_pagar, 'fecha_ing_nom_nov'=>$fecha_ing_nom_nov, 'fecha_fin_nom_nov'=>$fecha_fin_nom_nov, 'IGE'=>$IGE, 'LMA'=>$LMA);
		
		return $array_nomina_novedades;
	};
};

// Función obtener días de novedades nomina
$fn_dias_incapacidades=function($fn_explode_dato, $rr_periodo_pagar, $mes_per, $ano_per, $fecha_ing_nom_nov, $fecha_fin_nom_nov, $perio_nom){

	$dato_periodo=$fn_explode_dato($rr_periodo_pagar);
	
	//Verifico la cantidad del dato para agregarle el 0
	if(strlen($dato_periodo[0])==1) $dias_comienzo='0'.$dato_periodo[0];
	else $dias_comienzo=$dato_periodo[0];
	
	//Fechas iniciales para realizar las condiciones
	$fecha_partida=$ano_per."-".$mes_per."-00";
	$fecha_comienzo=$ano_per."-".$mes_per."-".$dias_comienzo;
	$fecha_final=$ano_per."-".$mes_per."-".$dato_periodo[1];	
	
	// Vigente, Comienza su incapacidad 
	if($fecha_ing_nom_nov>$fecha_partida && $fecha_ing_nom_nov>=$fecha_comienzo && $fecha_ing_nom_nov<=$fecha_final){
		$fecha1= new DateTime($fecha_ing_nom_nov);
		$fecha2= new DateTime($fecha_final);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;
	}
	// Vigente, Comienza su incapacidad y termina su incapacidad en el mismo periodo
	if($fecha_ing_nom_nov>$fecha_partida && $fecha_ing_nom_nov>=$fecha_comienzo && $fecha_ing_nom_nov<=$fecha_final && $fecha_fin_nom_nov<=$fecha_final){
		$fecha1= new DateTime($fecha_ing_nom_nov);
		$fecha2= new DateTime($fecha_fin_nom_nov);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;
	}
	// Termina su incapacidad con días proporcionales finales
	if($fecha_ing_nom_nov>$fecha_partida && $fecha_ing_nom_nov<$fecha_comienzo && $fecha_fin_nom_nov<$fecha_final){
		$fecha1= new DateTime($fecha_comienzo);
		$fecha2= new DateTime($fecha_fin_nom_nov);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days);
	}
	// Tiene vigente su incapacidad con el total de los días
	if($fecha_ing_nom_nov<$fecha_partida && $fecha_fin_nom_nov>$fecha_final) $total_dias=$dato_periodo[1];
	// No comienza su incapacidad
	if($fecha_ing_nom_nov>$fecha_final) $total_dias="";
	// Ya termino la incapacidad
	if($fecha_fin_nom_nov<$fecha_partida) $total_dias="";
	
	return $total_dias;
};

// Obtenemos el porcentaje de la incapacidad
$fn_obtener_porcentaje = function($array_porc_incap, $dias_total_incap){
    for($fila=0; $fila<count($array_porc_incap); $fila++):
        $dias_arr = $dias_total_incap;

        if($fila==0){
            if($dias_arr >= 0 && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }else{
            $fila_antes=$fila-1;
            if($dias_arr >= $array_porc_incap[$fila_antes]["dias_incap"] && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }
         
    endfor;
    return $factor/100;
};

// Calculamos el valor con el salario minimo y los dias de incapacidad
$fn_valor_porc_minimo=function($dias_total_incap, $salario_minimo, $dias_totales){
    return round($valor_porc_minimo=($salario_minimo / $dias_totales) * $dias_total_incap);
};

// Calculammos el valor de la incapacidad comparando el porcentaje
// tengamos en cuenta que si el valor con el calculo del porcentaje es menor al valor del salario minimo, el valor se calcula con el 100%
$fn_valor_incapacidades=function($dias, $fn_obtener_porcentaje, $array_porc_incap, $salario, $fn_valor_porc_minimo, $dias_totales, $salario_minimo){
    
    //Obtenemos el porcentaje de la BD mediante una fn
    $porcentaje=$fn_obtener_porcentaje($array_porc_incap, $dias);
    //Obtenemos el valor minimo a pagar mediante una fn
    $valor_porc_minimo=$fn_valor_porc_minimo($dias, $salario_minimo, $dias_totales);

    //Obtenemos el valor
    //Si el valor es mayor al salario minimo
    return "-".$valor_dias_salario = ((($salario / $dias_totales) * $dias) * $porcentaje);
    //Si el valor es menor al salario minimo, hágalo igual
    if($valor_dias_salario <= $valor_porc_minimo) $valor_dias_salario = $valor_porc_minimo;
    return $valor_dias_salario;
};

?>