<?php
// Calculo los días exactos laborados
$fn_dias_total_incap=function($fn_explode_fecha, $fecha_ini, $fecha_fin){
	
	//Obtengo los datos de las fechas en un array
	$array_dato_inicial=$fn_explode_fecha($fecha_ini);
	$array_dato_final=$fn_explode_fecha($fecha_fin);
	//Obtengo los datos de cada paisción
	$dia_inicial=$array_dato_inicial['dia'];
	$mes_inicial=$array_dato_inicial['mes'];
	$ano_inicial=$array_dato_inicial['ano'];
	$dia_final=$array_dato_final['dia'];
	$mes_final=$array_dato_final['mes'];
	$ano_final=$array_dato_final['ano'];

	//Aseguramos que el mayor número de días de un mes sea 30
	if($dia_final>30) $dia_final=30;
	if($dia_inicial>30) $dia_inicial=30;
	
	//Si las fechas están en el mismo año
	if($ano_final==$ano_inicial):

		//Resto los meses para obtener la cantidad de meses trabajados
		$cantidad_meses=$mes_final-$mes_inicial;
		//Obtengo la cantidad de días de los meses trabajados
		$dias_meses=$cantidad_meses*30;
		//Resto los días de las fechas para obtener los dias proporcionales
		$cantidad_dias=$dia_final-$dia_inicial+1;

		$total_dias=$dias_meses+$cantidad_dias;

		return $total_dias;

	else:
		
		//Calculo la diferencia de los años
		$cantidad_meses_ano=($ano_final-$ano_inicial)*12;
		//Para obtener la cantidad de meses es= meses que tiene el año, menos el mes inicial, más el mes final
		$cantidad_meses=$cantidad_meses_ano-$mes_inicial+$mes_final;	
		//Obtengo la cantidad de días de los meses trabajados
		$dias_meses=$cantidad_meses*30;
		//Resto los días de las fechas para obtener los dias proporcionales
		$cantidad_dias=$dia_final-$dia_inicial+1;

		$total_dias=$dias_meses+$cantidad_dias;

		return $total_dias;

	endif;
};

// Función obtener valores de novedades nomina
$fn_novedades=function($fn_nombre_novedades, $fn_dias_incapacidades, $fn_explode_dato, $rr_periodo_pagar, $base, $cc, $mes_per, $ano_per, $id_master, $cta_seleccionada, $perio_nom){

	//return var_dump($dato_fecha_fin);
	$sql="select cc_nom_nov, dias_nom_nov, fecha_ing_nom_nov, fecha_fin_nom_nov, tipo_nom_nov, id_nom_nov from nomina_novedades where cc_nom_nov=$cc and id_cta_fk_nom_nov=$cta_seleccionada and id_master_fk_nom_nov=$id_master and (tipo_nom_nov=2 or tipo_nom_nov=3) and liq_nom_nov=0";
	$conNOV=mysqli_query($base,$sql);
	while($resNOV=mysqli_fetch_assoc($conNOV)):

		$dato_periodo=$fn_explode_dato("-", $rr_periodo_pagar);
		$fecha_liquidacion=$ano_per."-".$mes_per."-".$dato_periodo[1];
		
		//echo "<br>cc: ".$cc;
		$id_nom_nov=$resNOV['id_nom_nov'];
		$fecha_ing_nom_nov=$resNOV['fecha_ing_nom_nov'];
		$fecha_fin_nom_nov=$resNOV['fecha_fin_nom_nov'];
		$tipo_nom_nov=$resNOV['tipo_nom_nov'];	
		if($tipo_nom_nov==2) $IGE='X';
		if($tipo_nom_nov==3) $LMA='X';

		if($fecha_fin_nom_nov<=$fecha_liquidacion): 
			$liquidacion_nov=1;
		else:
			$liquidacion_nov=0;
		endif;

		// Días a pagar de las incapacidades
		$r_dias_nom_nov_pagar=$fn_dias_incapacidades($fn_explode_dato, $rr_periodo_pagar, $mes_per, $ano_per, $fecha_ing_nom_nov, $fecha_fin_nom_nov, $perio_nom);

		// Si no tiene incapacidad descara las novedades
		//Marcalos las novedades vacías, porque no tienen días de incapacidad
		if($r_dias_nom_nov_pagar==''): 
			$IGE=''; 
			$LMA=''; 
			$fecha_ing_nom_nov='';
			$fecha_fin_nom_nov='';
		
		else:
			//Obtenemos el tipo de novedad
			$novedad=$fn_nombre_novedades($tipo_nom_nov);

			// Array con lo valores
			$array_nomina_novedades[]=array('id_nom_nov'=>$id_nom_nov, 'dias_nom_nov'=>$r_dias_nom_nov_pagar, 'fecha_ing_nom_nov'=>$fecha_ing_nom_nov, 'fecha_fin_nom_nov'=>$fecha_fin_nom_nov, 'liquidacion_nov'=>$liquidacion_nov, 'valor_nom_nov'=>'', 'novedad'=>$novedad, 'tipo_nom_nov'=>$tipo_nom_nov);

		endif;
	
	endwhile;

	return $array_nomina_novedades;
};

// Función obtener días de novedades nomina
$fn_dias_incapacidades=function($fn_explode_dato, $rr_periodo_pagar, $mes_per, $ano_per, $fecha_ing_nom_nov, $fecha_fin_nom_nov, $perio_nom){
	
	$dato_periodo=$fn_explode_dato("-", $rr_periodo_pagar);
	
	//Verifico la cantidad del dato para agregarle el 0
	if(strlen($dato_periodo[0])==1) $dias_comienzo='0'.$dato_periodo[0];
	else $dias_comienzo=$dato_periodo[0];
	
	//Fechas iniciales para realizar las condiciones
	$fecha_partida=$ano_per."-".$mes_per."-00";
	$fecha_comienzo=$ano_per."-".$mes_per."-".$dias_comienzo;
	$fecha_final=$ano_per."-".$mes_per."-".$dato_periodo[1];	
	
	// Vigente, Comienza su incapacidad y termina en el mismo periodo
	if($fecha_ing_nom_nov>$fecha_partida && $fecha_ing_nom_nov>=$fecha_comienzo && $fecha_fin_nom_nov<=$fecha_final){
		$fecha1= new DateTime($fecha_ing_nom_nov);
		$fecha2= new DateTime($fecha_fin_nom_nov);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;

		//echo "<br>entro 1: ".$total_dias;
	}

	// Vigente, Comienza su incapacidad en este periodo pero y termina en el próximo perido
	if($fecha_ing_nom_nov>$fecha_partida && $fecha_ing_nom_nov>=$fecha_comienzo && $fecha_fin_nom_nov>$fecha_final){
		$fecha1= new DateTime($fecha_ing_nom_nov);
		$fecha2= new DateTime($fecha_final);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;

		//echo "<br>entro 2: ".$total_dias;
	}

	// Comenzó su incapacidad en periodos anteriores y termina su incapacidad en este periodo
	if($fecha_ing_nom_nov<$fecha_partida && $fecha_fin_nom_nov<=$fecha_final){
		$fecha1= new DateTime($fecha_comienzo);
		$fecha2= new DateTime($fecha_fin_nom_nov);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;
		//echo "<br>entro 3: ".$total_dias;
	}

	// Comenzó su incapacidad en periodos anteriores y termina en periodos posteriores
	if($fecha_ing_nom_nov<$fecha_comienzo && $fecha_fin_nom_nov>$fecha_final){
		$fecha1= new DateTime($fecha_comienzo);
		$fecha2= new DateTime($fecha_final);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;
		//echo "<br>entro 4: ".$total_dias;
	}

	// Comenzó su incapacidad en periodos anteriores y termina en este periodo
	if($fecha_ing_nom_nov<$fecha_comienzo && $fecha_fin_nom_nov<=$fecha_final){
		$fecha1= new DateTime($fecha_comienzo);
		$fecha2= new DateTime($fecha_fin_nom_nov);
		$diff = $fecha1->diff($fecha2);
		$total_dias=($diff->days)+1;
		$total_dias;
	}

	// No comienza su incapacidad
	if($fecha_ing_nom_nov>$fecha_final) $total_dias="";
	// Ya termino la incapacidad
	if($fecha_fin_nom_nov<$fecha_partida) $total_dias="";
	
	return $total_dias;
};

// Obtenemos el porcentaje de la incapacidad
$fn_obtener_porcentaje = function($array_porc_incap, $dias_total_incap){
	
	
    /* FORMULA DEL ARRAY DE PORCENTAJES
	for($fila=0; $fila<count($array_porc_incap); $fila++):
        $dias_arr = $dias_total_incap;

        if($fila==0){
            if($dias_arr >= 0 && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }else{
            $fila_antes=$fila-1;
            if($dias_arr >= $array_porc_incap[$fila_antes]["dias_incap"] && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }
         
    endfor;
	*/

	if($dias_total_incap <= 90):
		$factor = "66.66";

	elseif($dias_total_incap > 90 && $dias_total_incap <= 180):
		$factor = "50";

	endif;

    return $factor/100;
};

// Calculamos el valor con el salario minimo y los dias de incapacidad
$fn_valor_porc_minimo=function($dias_total_incap, $salario_minimo, $dias_totales){
    return round($valor_porc_minimo=($salario_minimo / $dias_totales) * $dias_total_incap);
};

// Calculammos el valor de la incapacidad comparando el porcentaje
// tengamos en cuenta que si el valor con el calculo del porcentaje es menor al valor del salario minimo, el valor se calcula con el 100%
$fn_valor_incapacidades=function($dias, $fn_obtener_porcentaje, $array_porc_incap, $salario, $fn_valor_porc_minimo, $dias_totales, $salario_minimo, $tipo_nom_nov){
    
	/****************************
	 
    //Si la incapacidad e menor a 3 días
	if($dias <= 2):
		//Obtenemos el 100% del valor, este lo cancela la empresa
		$valor_dias_salario = ((($salario / $dias_totales) * $dias));
		$valor_dias_salario;
		return $valor_dias_salario;
	else:
	
	*****************************/

	if($dias < 2):

		$valor_dias_salario = ((($salario / $dias_totales) * $dias));
		$valor_dias_salario;
		return $valor_dias_salario;

	else:

		//Si la incapacidad es de maternidad ($tipo_nom_nov=3)
		if($tipo_nom_nov == 3):
			//Obtenemos el 100% del valor, este lo cancela la empresa
			$valor_dias_salario = ((($salario / $dias_totales) * $dias));
			$valor_dias_salario;
			return $valor_dias_salario;
		else:
			
			//Obtenemos el porcentaje de la BD mediante una fn
			$porcentaje=$fn_obtener_porcentaje($array_porc_incap, $dias);
			//Obtenemos el valor minimo a pagar mediante una fn
			echo "<br>valor_porc_minimo: ".$valor_porc_minimo=$fn_valor_porc_minimo($dias, $salario_minimo, $dias_totales);

			//Obtenemos el valor
			//Si el valor es mayor al salario minimo
			echo "<br>valor_porc_minimo: ".$valor_dias_salario = ((($salario / $dias_totales) * $dias) * $porcentaje);
			echo "<br>sma: ".$salario." - ".$dias_totales." - ".$dias." - ".$porcentaje;
			//Si el valor es menor al salario minimo, hágalo igual
			if($valor_dias_salario <= $valor_porc_minimo) $valor_dias_salario = $valor_porc_minimo;
			$valor_porc_minimo;
			$valor_dias_salario;
			return $valor_dias_salario;

		endif;
	endif;
	
	
};

?>