<?php
class MySQL {
    private $total_consultas;
    private $conexion;
    private $servidor = "localhost";
    public $clave;
    public $contrasena;
    public $bd;
    private $adiciono_campo;
    private $adiciono_tabla;
    private $elimino_bd;

    function __construct($cla, $contra, $base) { 
        $this->clave = $cla;
        $this->contrasena = $contra;
        $this->bd = $base;
    }

    public function ConectarFTP() {
        if (!isset($this->conexion)) {
            mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
            try {
                $this->conexion = mysqli_connect($this->servidor, $this->clave, $this->contrasena, $this->bd);
            } catch (mysqli_sql_exception $e) {
                die('Error al conectar a la base de datos: ' . $e->getMessage());
            }
        }
    }

    public function metodos($consulta) {
        $this->total_consultas++;
        $resultado = mysqli_query($this->conexion, $consulta);
        if (!$resultado) {
            echo 'MySQL error1: ' . mysqli_error($this->conexion);
            exit;
        }
        return $resultado;
    }

    public function consulta($consulta) {
        $this->total_consultas++;
        $resultado = mysqli_query($this->conexion, $consulta);
        if (!$resultado) {
            echo 'MySQL error2: ' . $consulta . ' - ' . mysqli_error($this->conexion);
            exit;
        }
        return $resultado;
    }

    public function cerrarconsulta($consulta) {
        mysqli_free_result($consulta);
    }

    public function fetch_array($consulta) {
        return mysqli_fetch_array($consulta);
    }

    public function fetch_assoc($consulta) {
        return mysqli_fetch_assoc($consulta);
    }

    public function num_rows($consulta) {
        return mysqli_num_rows($consulta);
    }

    public function TotalConsultas() {
        return $this->total_consultas;
    }

    public function EscaparCadenas($cadena) {
        return mysqli_real_escape_string($this->conexion, $cadena);
    }

    public function cerrarconexion() {
        mysqli_close($this->conexion);
    }
}
?>
